#!/bin/bash

source ./00_setup.sh

###############################################################################
# This runs the simulation - a simple pointed observation.
#
# The radec2xy tool is needed to add information used for region filtering
# to the event file.
###############################################################################


XMLDIR=$XRISM_INSTS/resolve

sixtesim \
  XMLFile=$XML \
  Simput=n132d_flat.simput \
  Prefix=output/${DET}_ \
  RA=$SrcRA Dec=$SrcDec \
  Exposure=${exp} \
  clobber=y

# radec2xy adds WCS coordinates to an event file
radec2xy EvtFile=output/${DET}_evt.fits \
  RefRA=$SrcRA RefDec=$SrcDec Projection=TAN
