#!/bin/bash

source ./00_setup.sh
################################################################################
# create an image of the source, one per detector
#
# depending on the instrument used, we use different binning of the sky image
################################################################################

# Resolve
if [ $DO_RSL -eq 1 ]; then
$SIXTE/bin/imgev                                \
    EvtFile=output/${DET}_evt.fits             \
    Image=output/${DET}_img.fits               \
    CoordinateSystem=0 Projection=TAN           \
    NAXIS1=6 NAXIS2=6                           \
    CUNIT1=deg CUNIT2=deg                       \
    CRVAL1=$SrcRA CRVAL2=$SrcDec \
    CRPIX1=3.5 CRPIX2=3.5                       \
    CDELT1=-85.12516e-04 CDELT2=85.12516e-04    \
    history=true clobber=yes
else
$SIXTE/bin/imgev                                \
    EvtFile=output/${DET}_evt.fits             \
    Image=output/${DET}_img.fits               \
    CoordinateSystem=0 Projection=TAN           \
    NAXIS1=50 NAXIS2=50                           \
    CUNIT1=deg CUNIT2=deg                       \
    CRVAL1=$SrcRA CRVAL2=$SrcDec \
    CRPIX1=25.5 CRPIX2=25.5                      \
    CDELT1=-1.5136e-3 CDELT2=1.5136e-3    \
    history=true clobber=yes
fi
